/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby;

import com.aptana.editor.ruby.QueuedToken;
import com.aptana.editor.ruby.RubyTokenScanner;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;

public class RubyCodeScanner
implements ITokenScanner {
    private RubyTokenScanner fScanner = new RubyTokenScanner();
    private boolean nextIsMethodName;
    private boolean nextIsModuleName;
    private boolean nextIsClassName;
    private boolean inPipe;
    private boolean lookForBlock;
    private boolean nextAreArgs;
    private List<QueuedToken> queue;
    private int fLength;
    private int fOffset;
    private int fOrigOffset;

    public int getTokenLength() {
        return this.fLength;
    }

    public int getTokenOffset() {
        return this.fOffset;
    }

    public IToken nextToken() {
        IToken intToken = this.pop();
        if (intToken.isEOF()) {
            return Token.EOF;
        }
        Integer data = (Integer)intToken.getData();
        if (this.lookForBlock && !this.inPipe && data != 358 && data != 382) {
            this.lookForBlock = false;
        }
        if (this.nextAreArgs && (this.isNewline(data) || data == 59)) {
            this.nextAreArgs = false;
        }
        if (this.isKeyword(data)) {
            switch (data) {
                case 286: 
                case 302: 
                case 303: {
                    if (this.nextIsClassName) {
                        this.nextIsClassName = false;
                        return this.getToken("entity.name.type.class.ruby");
                    }
                    return this.getToken("variable.language.ruby");
                }
                case 287: 
                case 288: 
                case 289: {
                    return this.getToken("constant.language.ruby");
                }
                case 290: 
                case 291: 
                case 292: {
                    return this.getToken("keyword.operator.logical.ruby");
                }
                case 280: 
                case 282: {
                    this.lookForBlock = true;
                    return this.getToken("keyword.control.start-block.ruby");
                }
                case 257: {
                    this.nextAreArgs = false;
                    this.nextIsClassName = true;
                    return this.getToken("keyword.control.class.ruby");
                }
                case 258: {
                    this.nextAreArgs = false;
                    this.nextIsModuleName = true;
                    return this.getToken("keyword.control.module.ruby");
                }
                case 259: {
                    this.nextAreArgs = false;
                    this.nextIsMethodName = true;
                    return this.getToken("keyword.control.def.ruby");
                }
            }
            if (this.nextIsMethodName) {
                this.nextIsMethodName = false;
                this.nextAreArgs = true;
                return this.getToken("entity.name.function.ruby");
            }
            return this.getToken("keyword.control.ruby");
        }
        switch (data) {
            case 61: {
                return this.getToken("keyword.operator.assignment.ruby");
            }
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 326: 
            case 327: 
            case 356: 
            case 357: {
                if (this.nextIsMethodName) {
                    this.nextIsMethodName = false;
                    this.nextAreArgs = true;
                    return this.getToken("entity.name.function.ruby");
                }
                return this.getToken("keyword.operator.comparison.ruby");
            }
            case 347: {
                if (this.nextAreArgs) {
                    return this.getToken("variable.parameter.function.ruby");
                }
            }
            case 317: 
            case 348: 
            case 349: 
            case 352: 
            case 353: 
            case 354: 
            case 355: {
                if (this.nextIsMethodName) {
                    this.nextIsMethodName = false;
                    this.nextAreArgs = true;
                    return this.getToken("entity.name.function.ruby");
                }
                return this.getToken("keyword.operator.arithmetic.ruby");
            }
            case 63: 
            case 324: 
            case 325: 
            case 350: 
            case 351: 
            case 359: 
            case 360: {
                if (this.nextIsMethodName) {
                    this.nextIsMethodName = false;
                    this.nextAreArgs = true;
                    return this.getToken("entity.name.function.ruby");
                }
                return this.getToken("keyword.operator.logical.ruby");
            }
            case 314: 
            case 315: 
            case 316: 
            case 331: 
            case 332: {
                this.nextIsMethodName = false;
                this.nextAreArgs = true;
                return this.getToken("entity.name.function.ruby");
            }
            case 358: {
                if (this.lookForBlock) {
                    boolean bl = this.inPipe = !this.inPipe;
                    if (!this.inPipe) {
                        this.lookForBlock = false;
                    }
                    return this.getToken("punctuation.separator.variable.ruby");
                }
                if (this.nextIsMethodName) {
                    this.nextIsMethodName = false;
                    this.nextAreArgs = true;
                    return this.getToken("entity.name.function.ruby");
                }
                return this.getToken("keyword.operator.logical.ruby");
            }
            case 339: 
            case 340: {
                if (this.nextAreArgs) {
                    return this.getToken("punctuation.definition.parameters.ruby");
                }
                return this.getToken("punctuation.section.function.ruby");
            }
            case 345: {
                this.lookForBlock = true;
                return this.getToken("punctuation.section.scope.ruby");
            }
            case 343: 
            case 344: {
                return this.getToken("punctuation.section.array.ruby");
            }
            case 361: 
            case 362: {
                return this.getToken("punctuation.section.scope.ruby");
            }
            case 44: {
                return this.getToken("punctuation.separator.object.ruby");
            }
            case 341: {
                if (this.nextAreArgs) {
                    this.nextAreArgs = false;
                    return this.getToken("punctuation.definition.parameters.ruby");
                }
                return this.getToken("punctuation.section.function.ruby");
            }
            case 333: {
                if (this.nextIsClassName) {
                    return this.getToken("entity.name.type.class.ruby");
                }
                if (this.nextIsMethodName) {
                    this.nextIsMethodName = false;
                    this.nextAreArgs = true;
                    return this.getToken("entity.name.function.ruby");
                }
                return this.getToken("keyword.operator.assignment.augmented.ruby");
            }
            case 337: {
                return this.getToken("keyword.operator.assignment.augmented.ruby");
            }
            case 338: {
                return this.getToken("punctuation.separator.key-value");
            }
            case 128: {
                return this.getToken("constant.character.ruby");
            }
            case 335: 
            case 336: {
                return this.getToken("punctuation.separator.inheritance.ruby");
            }
            case 378: 
            case 379: {
                return this.getToken("constant.numeric.ruby");
            }
            case 364: {
                return this.getToken("constant.other.symbol.ruby");
            }
            case 308: {
                return this.getToken("variable.other.readwrite.global.ruby");
            }
            case 309: {
                return this.getToken("variable.other.readwrite.instance.ruby");
            }
            case 311: {
                return this.getToken("variable.other.readwrite.class.ruby");
            }
            case 310: {
                if (this.nextIsModuleName) {
                    this.nextIsModuleName = false;
                    return this.getToken("entity.name.type.module.ruby");
                }
                if (this.nextIsClassName) {
                    this.nextIsClassName = false;
                    return this.getToken("entity.name.type.class.ruby");
                }
                int nextToken = this.peek();
                if (nextToken == 335 || nextToken == 328) {
                    return this.getToken("support.class.ruby");
                }
                return this.getToken("variable.other.constant.ruby");
            }
            case 256: {
                return this.getToken("error.ruby");
            }
            case 382: {
                return Token.WHITESPACE;
            }
            case 328: {
                return this.getToken("punctuation.separator.method.ruby");
            }
            case 306: 
            case 307: {
                if (this.nextIsMethodName) {
                    this.nextIsMethodName = false;
                    this.nextAreArgs = true;
                    return this.getToken("entity.name.function.ruby");
                }
                if (this.nextAreArgs) {
                    return this.getToken("variable.parameter.function.ruby");
                }
                if (this.lookForBlock && this.inPipe) {
                    return this.getToken("variable.other.block.ruby");
                }
                if (!"new".equals(this.getSourceForCurrentToken())) break;
                return this.getToken("keyword.other.special-method.ruby");
            }
        }
        return this.getToken("");
    }

    protected boolean isNewline(Integer data) {
        if (data == 10) {
            return true;
        }
        if (data != 382) {
            return false;
        }
        String tokenSrc = this.getSourceForCurrentToken();
        if (tokenSrc == null) {
            return false;
        }
        return tokenSrc.equals("\r\n") || tokenSrc.equals("\n") || tokenSrc.equals("\r");
    }

    private String getSourceForCurrentToken() {
        return this.fScanner.getSource(this.fOffset - this.fOrigOffset, this.fLength);
    }

    protected IToken getToken(String tokenName) {
        return new Token((Object)tokenName);
    }

    private IToken pop() {
        IToken intToken = null;
        if (this.queue == null || this.queue.isEmpty()) {
            intToken = this.fScanner.nextToken();
            this.fOffset = this.fScanner.getTokenOffset();
            this.fLength = this.fScanner.getTokenLength();
        } else {
            QueuedToken queued = this.queue.remove(0);
            this.fOffset = queued.getOffset();
            this.fLength = queued.getLength();
            intToken = queued.getToken();
        }
        if (intToken == null) {
            return Token.EOF;
        }
        Integer data = (Integer)intToken.getData();
        if (data == null) {
            return Token.EOF;
        }
        return intToken;
    }

    private int peek() {
        int oldOffset = this.getTokenOffset();
        int oldLength = this.getTokenLength();
        IToken next = this.pop();
        this.push(next);
        this.fOffset = oldOffset;
        this.fLength = oldLength;
        if (next.isEOF()) {
            return -1;
        }
        Integer data = (Integer)next.getData();
        return data;
    }

    private void push(IToken next) {
        if (this.queue == null) {
            this.queue = new Vector<QueuedToken>();
        }
        this.queue.add(new QueuedToken(next, this.getTokenOffset(), this.getTokenLength()));
    }

    public void setRange(IDocument document, int offset, int length) {
        this.fScanner.setRange(document, offset, length);
        this.reset();
        this.fOrigOffset = offset;
    }

    private void reset() {
        this.nextIsMethodName = false;
        this.nextIsModuleName = false;
        this.nextIsClassName = false;
        this.inPipe = false;
        this.lookForBlock = false;
        this.nextAreArgs = false;
        this.queue = null;
    }

    private boolean isKeyword(int i) {
        return i >= 257 && i <= 305;
    }
}

